/*
 * Datarecord.h -- encode Station information
 *
 * (c) 2003 Dr. Andreas Mueller, Beratung und Entwicklung
 *
 * $Id: Datarecord.h,v 1.8 2004/02/25 23:52:34 afm Exp $
 */
#ifndef _Datarecord_h
#define _Datarecord_h

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif /* HAVE_SYS_TYPES_H */
#include <time.h>
#include <string>
#include <map>
#include <Value.h>

namespace meteo {

typedef std::map<std::string, Value>	valuemap_t;

class	Datarecord {
	valuemap_t	data;
	time_t		timekey;

	// add fields to the data record, this should only be done by friends
	void	addField(const std::string& fieldname, const Value& v);
public:
	// construction
	Datarecord() { }
	~Datarecord(void) { }

	// accessors for non meteo data
	void	setTimekey(time_t key) { timekey = key; }
	time_t	getTimekey(void) const { return timekey; }

	// accessor for display
	std::string	xml(const std::string& stationname) const;
	std::string	plain(const std::string& stationname) const;

	// retrieve data by field name
	Value	getValue(const std::string& fieldname) const;

	// Datarecords are primarily generated by the QueryProcessor
	friend class QueryProcessor;
};

} /* namespace meteo */

#endif /* _Datarecord_h */
